//===============================================================================
// Microsoft patterns & practices Enterprise Library
// Configuration Application Block
//===============================================================================
// Copyright  Microsoft Corporation.  All rights reserved.
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY
// OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT
// LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE.
//===============================================================================

using System;
using System.ComponentModel;
using System.Configuration;

namespace Microsoft.Practices.EnterpriseLibrary.Configuration
{
	/// <summary>
	/// Represents a <see cref="ConfigurationElement"/> that has a name and type.
	/// </summary>
	public class NameTypeConfigurationElement : NamedConfigurationElement
	{
		private const string typeProperty = "type";

		/// <summary>
		/// Intialzie an instance of the <see cref="NameTypeConfigurationElement"/> class.
		/// </summary>
		public NameTypeConfigurationElement()
		{
		}

		/// <summary>
		/// Initialize an instance of the <see cref="NameTypeConfigurationElement"/> class
		/// </summary>
		/// <param name="name">The name of the element.</param>
		/// <param name="type">The <see cref="Type"/> that this element is the configuraiton for.</param>
		public NameTypeConfigurationElement(string name, Type type) : base(name)
		{			
			this.Type = type;
		}		

		/// <summary>
		/// Gets or sets the <see cref="Type"/> the element is the configuration for.
		/// </summary>
		/// <value>
		/// The <see cref="Type"/> the element is the configuration for.
		/// </value>
		[ConfigurationProperty(typeProperty, RequiredValue = true)]
		[TypeConverter(typeof(AssemblyQualifiedTypeNameConverter))]		
		public Type Type
		{
			get
			{
				return (Type)this[typeProperty];
			}
			set
			{
				this[typeProperty] = value;
			}
		}		
	}
}
